-- BTR-4 by Currenthill

-- =========================== 7.62x54 CARTRIDGES =======================================

declare_weapon({
	category 				= CAT_SHELLS,
	name 					= "BTR4_7_62_T", 
	user_name 				= _("7.62 mm"),
	model_name    			= "tracer_bullet_green",
	v0    					= 820	,
	Dv0   					= 0.0082,
	Da0     				= 0.0004,
	Da1     				= 0.0,
	mass      				= 0.0119,
	explosive     			= 0.0000,
	life_time     			= 7,
	caliber     			= 7.62,
	s        				= 0.0,
	j        				= 0.0,
	l        				= 0.0,
	charTime    			= 0,
	cx        				= {1.0,0.62,0.65,0.175,1.8},
	k1        				= 2.9e-08, 
	tracer_off    			= 3,
	scale_tracer  			= 1,
	cartridge 				= 0,	
	
});

declare_weapon({
	category 				= CAT_SHELLS,
	name 					= "BTR4_7_62", 
	user_name 				= _("7.62 mm"),
	model_name    			= "tracer_bullet_green",
	v0    					= 820	,
	Dv0   					= 0.0082,
	Da0     				= 0.0004,
	Da1     				= 0.0,
	mass      				= 0.0119,
	explosive     			= 0.0000,
	life_time     			= 7,
	caliber     			= 7.62,
	s        				= 0.0,
	j        				= 0.0,
	l        				= 0.0,
	charTime    			= 0,
	cx        				= {1.0,0.62,0.65,0.175,1.8},
	k1        				= 2.9e-08,
	tracer_off    			= -100,
	scale_tracer  			= 1,
	cartridge 				= 0,	
	
});

-- =======================================  30 x 165 mm SHELLS =======================================

declare_weapon({
	category 				= CAT_SHELLS,
	name 					= "BTR4_APDS_T", 
	user_name 				= _("30 mm APDS-T"),
	model_name    			= "tracer_bullet_green",
	v0    					= 1120.0,
	Dv0   					= 0.0081,
	Da0     				= 0.0005,
	Da1     				= 0.0,
	mass      				= 0.390,
	round_mass 				= 0.98,	
	-- explosive     			= 0.304,
	life_time     			= 10,
	caliber    				= 30.0,
	AP_cap_caliber 			= 35.0,
	-- subcalibre     			= true,	
	s         				= 0.0,
	j         				= 0.0,
	l         				= 0.0,
	charTime    			= 0,
	cx        				= {0.7,0.70,0.25,0.236,2.31},
	k1        				= 5.7e-09,
	tracer_off    			= 10,
	scale_tracer  			= 1,
	cartridge 				= 0,
	
});

declare_weapon({
	category 				= CAT_SHELLS,
	name 					= "BTR4_HEI", 
	user_name 				= _("30 mm HEI"),
	model_name    			= "tracer_bullet_green",
	v0        				= 960.0,
	Dv0   					= 0.0081,
	Da0     				= 0.0005,
	Da1     				= 0.0,
	mass      				= 0.390,
	round_mass 				= 0.98,
	explosive     			= 0.390,
	life_time     			= 9,
	caliber     			= 30.0,
	s         				= 0.0,
	j         				= 0.0,
	l         				= 0.0,
	charTime    			= 0,
	cx        				= {0.7,0.70,0.25,0.236,2.31},
	k1       	 			= 6.0e-09,
	tracer_off    			= -100,
	scale_tracer  			= 1,
	cartridge 				= 0,
	
});

-- =======================================  30 x 29 mm SHELLS =======================================

declare_weapon({
	category 				= CAT_SHELLS,
	name 					= "BTR4_VOG30", 
	user_name 				= _("30 mm HE"),
	model_name    			= "tracer_bullet_green",
	v0    					= 185.0;
	Dv0     				= 0.009,
	Da0     				= 0.0011,
	Da1     				= 0.0015,
	mass      				= 0.350,
	explosive     			= 0.350, -- 0.034 kg in real
	life_time     			= 35,
	caliber     			= 30.0,
	s         				= 0.0,
	j         				= 0.0,
	l         				= 0.0,
	charTime    			= 0,
	cx        				= {1.0,0.71,0.44,0.294,1.47},
	k1        				= 6.0e-08,
	tracer_on    			= 0.5,
	tracer_off    			= -100,
	scale_tracer  			= 0,
	cartridge 				= 0,
	
});

-- =========================== ZTM-1 30 mm autocannon =======================================

GT_t.LN_t.BTR4_ZTM_1 = {name = "ZTM-1", display_name = _("ZTM-1")}
GT_t.LN_t.BTR4_ZTM_1.type = 3
GT_t.LN_t.BTR4_ZTM_1.distanceMin = 10
GT_t.LN_t.BTR4_ZTM_1.distanceMax = 2000
GT_t.LN_t.BTR4_ZTM_1.max_trg_alt = 2000
GT_t.LN_t.BTR4_ZTM_1.reactionTime = 1.0
GT_t.LN_t.BTR4_ZTM_1.sensor = {}
set_recursive_metatable(GT_t.LN_t.BTR4_ZTM_1.sensor, GT_t.WSN_t[7])
GT_t.LN_t.BTR4_ZTM_1.PL = {}
GT_t.LN_t.BTR4_ZTM_1.PL[1] = {}
GT_t.LN_t.BTR4_ZTM_1.PL[1].ammo_capacity = 200
GT_t.LN_t.BTR4_ZTM_1.PL[1].automaticLoader = false;
GT_t.LN_t.BTR4_ZTM_1.PL[1].shell_name = {"BTR4_APDS_T"};
GT_t.LN_t.BTR4_ZTM_1.PL[1].shot_delay = 60/330
GT_t.LN_t.BTR4_ZTM_1.BR = { {pos = {5.2, 0, 0} } }

-- =========================== KT 7.62 mm machine gun =======================================

GT_t.LN_t.BTR4_KT = {name = "KT 7.62", display_name = _("KT 7.62")}
GT_t.LN_t.BTR4_KT.type = 10
GT_t.LN_t.BTR4_KT.distanceMin = 1
GT_t.LN_t.BTR4_KT.distanceMax = 1200
GT_t.LN_t.BTR4_KT.max_trg_alt = 1200
GT_t.LN_t.BTR4_KT.reactionTime = 0.5
GT_t.LN_t.BTR4_KT.sensor = {}
set_recursive_metatable(GT_t.LN_t.BTR4_KT.sensor, GT_t.WSN_t[7])
GT_t.LN_t.BTR4_KT.PL = {}
GT_t.LN_t.BTR4_KT.PL[1] = {}
GT_t.LN_t.BTR4_KT.PL[1].ammo_capacity = 250
GT_t.LN_t.BTR4_KT.PL[1].switch_on_delay = 15
GT_t.LN_t.BTR4_KT.PL[1].portionAmmoCapacity = 250
GT_t.LN_t.BTR4_KT.PL[1].reload_time = 15
GT_t.LN_t.BTR4_KT.PL[1].shell_name = {"BTR4_7_62_T", "BTR4_7_62"};
GT_t.LN_t.BTR4_KT.PL[1].shot_delay = 60/650
GT_t.LN_t.BTR4_KT.BR = { {pos = {5.2, 0, 0} } }
for i=2,8 do
    GT_t.LN_t.BTR4_KT.PL[i] = {};
    set_recursive_metatable(GT_t.LN_t.BTR4_KT.PL[i], GT_t.LN_t.BTR4_KT.PL[1]);
end;

-- =========================== AG-17 30 mm grenade launcher ==================================

GT_t.LN_t.BTR4_AG17 = {name = "AG-17", display_name = _("AG-17")};
GT_t.LN_t.BTR4_AG17.type = 9;
GT_t.LN_t.BTR4_AG17.distanceMin = 10;
GT_t.LN_t.BTR4_AG17.distanceMax = 1200;
GT_t.LN_t.BTR4_AG17.max_trg_alt = 1200;
GT_t.LN_t.BTR4_AG17.sensor = {}
set_recursive_metatable(GT_t.LN_t.BTR4_AG17.sensor, GT_t.WSN_t[7])
GT_t.LN_t.BTR4_AG17.PL = {}
GT_t.LN_t.BTR4_AG17.PL[1] = {};
GT_t.LN_t.BTR4_AG17.PL[1].switch_on_delay = 15;
GT_t.LN_t.BTR4_AG17.PL[1].reload_time = 15;
GT_t.LN_t.BTR4_AG17.PL[1].portionAmmoCapacity = 29;
GT_t.LN_t.BTR4_AG17.PL[1].shell_name = {"BTR4_VOG30"};
GT_t.LN_t.BTR4_AG17.PL[1].ammo_capacity = 29; 
GT_t.LN_t.BTR4_AG17.PL[1].shot_delay = 60/400; 
GT_t.LN_t.BTR4_AG17.BR = { {pos = {0.2, 0.0, 0}}}
for i=2,3 do
    GT_t.LN_t.BTR4_AG17.PL[i] = {};
    set_recursive_metatable(GT_t.LN_t.BTR4_AG17.PL[i], GT_t.LN_t.BTR4_AG17.PL[1]);
end;
